/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.linker;

import filenet.vw.apps.linker.VWDocumentClassLinkPanel;
import filenet.vw.apps.linker.VWDocumentLinkPanel;
import filenet.vw.apps.linker.VWLinkerCriteriaPanel;
import filenet.vw.apps.linker.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMAuthToken;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMLibrary;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.VWBaseAppLauncherApplet;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class VWLinkerPanel
extends JPanel
implements ActionListener {
    private JPanel m_centerPanel = null;
    private JButton m_selectButton = null;
    private JButton m_closeButton = null;
    private JButton m_helpButton = null;
    private Container m_mainContainer = null;
    private Frame m_parentFrame = null;
    private int m_nLinkType = -1;

    public void init(VWSessionInfo sessionInfo) {
        String libraryName = null;
        String linkType = null;
        String documentId = null;
        try {
            this.m_mainContainer = sessionInfo.getParentContainer();
            libraryName = sessionInfo.getProperty("library");
            linkType = sessionInfo.getProperty("linkType");
            documentId = sessionInfo.getProperty("docId");
            this.m_parentFrame = VWModalDialog.getParentFrameUsingContainer(this.m_mainContainer);
            if (libraryName == null || linkType == null) {
                this.displayCriteriaPanel();
            } else {
                this.displayLinkingPanel(libraryName, linkType, documentId);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void destroy() {
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object object = event.getSource();
            if (object == this.m_selectButton) {
                if (this.m_centerPanel != null && this.m_centerPanel instanceof VWLinkerCriteriaPanel) {
                    String libraryName = ((VWLinkerCriteriaPanel)this.m_centerPanel).getLibraryName();
                    String linkType = ((VWLinkerCriteriaPanel)this.m_centerPanel).getLinkType();
                    String documentId = ((VWLinkerCriteriaPanel)this.m_centerPanel).getDocumentId();
                    this.displayLinkingPanel(libraryName, linkType, documentId);
                }
            } else if (object == this.m_closeButton) {
                this.exitApplication();
            } else if (object == this.m_helpButton) {
                switch (this.m_nLinkType) {
                    case 3: {
                        VWHelp.displayPage(VWHelp.Help_eProcess_Doc + "link/vwlinkworkflow.htm");
                        break;
                    }
                    case 2: {
                        VWHelp.displayPage(VWHelp.Help_eProcess_Doc + "link/vwlinkdocument.htm");
                        break;
                    }
                    case 1: {
                        VWHelp.displayPage(VWHelp.Help_eProcess_Doc + "link/vwlinkdocumentclass.htm");
                        break;
                    }
                    default: {
                        VWHelp.displayPage(VWHelp.Help_eProcess_Doc + "link/vwlinkcriteria.htm");
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void displayCriteriaPanel() {
        try {
            this.layoutControls(new VWLinkerCriteriaPanel(this.m_parentFrame), true);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void displayLinkingPanel(String libraryName, String linkType, String documentId) {
        IVWIDMLibrary library = null;
        JPanel centerPanel = null;
        try {
            library = VWIDMBaseFactory.instance().getIDMLibrary(libraryName);
            if (!library.hasWorkflowLinkSupport()) {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.LibDoesNotSupportWFLink.toString(libraryName), VWResource.ErrorMessage, 0);
                return;
            }
            IVWIDMAuthToken vwSessToken = VWIDMBaseFactory.instance().getVWSessionToken();
            if (vwSessToken != null) {
                library.initForLinking(vwSessToken.getRouterURL(), vwSessToken.getUserName(), vwSessToken.getPassword(), vwSessToken.getToken());
            }
            if (VWStringUtils.compare(linkType, "1") == 0) {
                this.m_nLinkType = 1;
                centerPanel = new VWDocumentClassLinkPanel(this.m_parentFrame, library);
            } else if (VWStringUtils.compare(linkType, "2") == 0) {
                IVWIDMDocument document = null;
                try {
                    if (documentId != null) {
                        document = library.getDocument(documentId);
                    }
                    this.m_nLinkType = document != null && document.isWorkflowDefinition() ? 3 : 2;
                }
                catch (Exception ex) {
                    VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
                    return;
                }
                centerPanel = new VWDocumentLinkPanel(this.m_parentFrame, library, this.m_nLinkType, document);
            } else {
                JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.InvalidType, VWResource.ErrorMessage, 0);
                return;
            }
            this.layoutControls(centerPanel, false);
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
        }
    }

    private void layoutControls(JPanel centerPanel, boolean bIsCriteria) {
        try {
            this.m_centerPanel = centerPanel;
            this.setLayout(new BorderLayout());
            this.add((Component)centerPanel, "Center");
            this.add((Component)this.createButtonPanel(bIsCriteria), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        if (this.m_mainContainer != null) {
            this.m_mainContainer.invalidate();
            this.m_mainContainer.validate();
            this.m_mainContainer.repaint();
        }
    }

    private JPanel createButtonPanel(boolean bIsCriteria) {
        JPanel subPanel = null;
        GridBagConstraints gbConst = null;
        try {
            subPanel = new JPanel();
            subPanel.setLayout(new GridBagLayout());
            gbConst = new GridBagConstraints();
            gbConst.fill = 2;
            gbConst.gridwidth = 2;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(10, 10, 10, 10);
            if (bIsCriteria) {
                this.m_selectButton = new JButton(VWResource.Select);
                this.m_selectButton.addActionListener(this);
                subPanel.add((Component)this.m_selectButton, gbConst);
            }
            this.m_closeButton = new JButton(VWResource.Close);
            this.m_closeButton.addActionListener(this);
            subPanel.add((Component)this.m_closeButton, gbConst);
            this.m_helpButton = new JButton(VWResource.Help);
            this.m_helpButton.addActionListener(this);
            subPanel.add((Component)this.m_helpButton, gbConst);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return subPanel;
    }

    private void exitApplication() {
        try {
            if (this.m_mainContainer != null && this.m_mainContainer instanceof JFrame) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent((JFrame)this.m_mainContainer, 201));
            } else if (this.m_mainContainer != null && this.m_mainContainer instanceof VWBaseAppLauncherApplet) {
                ((VWBaseAppLauncherApplet)this.m_mainContainer).closeWindow();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

